# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Activate publishing features
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Feature id for the site collection publishing feature
$featureSiteCollection = [GUID]"f6924d36-2fa8-4f0b-b16d-06b7250180fa"

# Feature id for the site publishing feature
$featureSite = [GUID]"94c94ca6-b32f-4da9-a9e3-1f3d343d7ecb"

# Get the SharePoint site
$web = Get-SPWeb $webUrl
	
# Ensure the Publishing Infrastructure Site Collection feature is enabled
if ($web.Site.Features[$featureSiteCollection] -eq $null)
{
	$web.Site.Features.Add($featureSiteCollection)
}

# Ensure the Site Publishing feature is enabled
if ($web.Features[$featureSite] -eq $null)
{
	$web.Features.Add($featureSite)
}

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 